require 'recipecode'

function Recipe.OnCreate.FromConditionInheriter(craftRecipeData, player)
    local items = craftRecipeData:getAllConsumedItems();
    local results = craftRecipeData:getAllCreatedItems()
    local box = items:get(0);

    for i = 0, results:size() - 1 do
        local resultItem = results:get(i);
        if box:getModData()["condition" .. i] then
            resultItem:setCondition(box:getModData()["condition" .. i])
        end
    end
end

function Recipe.OnCreate.ToConditionInheriter(craftRecipeData, player)
    local results = craftRecipeData:getAllCreatedItems()
    local items = craftRecipeData:getAllConsumedItems();

    local box = results:get(0);
    for i = 0, items:size() - 1 do
        local item = items:get(i);
        if item:getCondition() ~= item:getConditionMax() then
            box:getModData()["condition" .. i] = item:getCondition();
        end
    end
end